/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.pay.wx;

import cn.hutool.core.net.URLEncoder;
import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.wx.request.WxH5PrePayRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxH5PreOrderAction
extends PayPlatformAction<WxH5PrePayRequest> {
    private static final Logger log = LoggerFactory.getLogger(WxH5PreOrderAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private ThirdPartyConfigProperties partyConfigProperties;

    @Override
    public Message exec(WxH5PrePayRequest request) {
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByAppIdAndMchId(request.getAppId(), request.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();
        prePaymentResponse.setRequestId(ThreadContext.getRequestId());
        if (request.getMock().booleanValue()) {
            prePaymentResponse.setSuccess(Boolean.valueOf(true));
            return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
        }
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getRequestOrderNo());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType("MWEB");
        wxPayUnifiedOrderRequest.setNotifyUrl(this.partyConfigProperties.getServerUrl() + this.partyConfigProperties.getWxPayCallbackUrl() + "/" + request.getAccountId() + "/" + request.getRequestOrderNo());
        try {
            WxPayMwebOrderResult execute = (WxPayMwebOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
            String returnUrl = this.builderReturnUrl(request);
            String mwebUrl = execute.getMwebUrl();
            if (null != returnUrl) {
                mwebUrl = mwebUrl + "&redirect_url=" + URLEncoder.createAll().encode(returnUrl, StandardCharsets.UTF_8);
            }
            prePaymentResponse.setLink(mwebUrl);
            prePaymentResponse.setSuccess(Boolean.valueOf(true));
        }
        catch (WxPayException e) {
            log.error("\u8c03\u7528\u5fae\u4fe1H5\u9884\u652f\u4ed8\u5931\u8d25\uff0cparam:{},exception\uff1a", (Object)request, (Object)e);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u5fae\u4fe1H5\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
    }

    public String builderReturnUrl(WxH5PrePayRequest request) {
        if (request.getReturnUrl() != null) {
            log.info("\u83b7\u53d6\u5230returnUrl:{}", (Object)request.getReturnUrl());
            String returnUrl = request.getReturnUrl();
            returnUrl = returnUrl + (returnUrl.contains("?") ? "&" : "?");
            returnUrl = returnUrl + "orderNo=" + request.getOrderNo();
            log.info("\u5904\u7406\u540e\u7684\u83b7\u53d6\u5230returnUrl:{}", (Object)returnUrl);
            return returnUrl;
        }
        log.error("\u8bf7\u6c42\u4e2d\u4e0d\u5305\u542breturnUrl\u53c2\u6570,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)request));
        return null;
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}

