/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.refund.ali;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.refund.ali.request.AlipayRefundRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayRefundOrderAction
extends PayPlatformAction<AlipayRefundRequest> {
    private static final Logger log = LoggerFactory.getLogger(AlipayRefundOrderAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;
    public static final String ALIPAY_SUCCESS_CODE = "10000";

    @Override
    public Message exec(AlipayRefundRequest request) {
        PaymentOrderV2Entity paymentOrderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(request.getOrderNo());
        AlipayClient alipayClient = this.paymentConfigFacadeService.getAliClientByMchId(paymentOrderV2Entity.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        RefundResponse refundResponse = new RefundResponse();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setTradeNo(paymentOrderV2Entity.getThirdPartyTradeNo());
        model.setOutRequestNo(request.getRequestOrderNo());
        model.setRefundAmount(NumberUtils.format((double)request.getRefundAmount().setScale(2, RoundingMode.HALF_DOWN).floatValue()));
        model.setRefundReason(request.getReason());
        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel((AlipayObject)model);
        AlipayTradeRefundResponse execute = null;
        try {
            execute = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)tradeRefundRequest);
            refundResponse.setResult(JSON.toJSONString((Object)execute));
            if (!StringUtils.equals((CharSequence)execute.getCode(), (CharSequence)ALIPAY_SUCCESS_CODE)) {
                log.error("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff0cparam:{},execute\uff1a{}", (Object)request, (Object)execute);
            }
            refundResponse.setThirdPartyOrderNo(execute.getTradeNo());
            refundResponse.setSuccess(Boolean.valueOf(StringUtils.equals((CharSequence)execute.getCode(), (CharSequence)ALIPAY_SUCCESS_CODE)));
            refundResponse.setErrorMsg(execute.getSubMsg());
            refundResponse.setOutOrderNo(request.getOrderNo());
            refundResponse.setPaymentOrderNo(paymentOrderV2Entity.getOrderNo());
            refundResponse.setRefundOrderNo(request.getRequestOrderNo());
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff0cparam:{},exception\uff1a", (Object)request, (Object)e);
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u5b9d\u7533\u8bf7\u9000\u6b3e\u5931\u8d25," + e.getMessage());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)refundResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.REFUND;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}

