/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.withdraw.wx;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.WxErrorEnum;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.wx.request.WxWithdrawRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.enums.WithdrawErrorTypeEnum;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.bxm.thirdparty.platform.service.PaymentAccountBalanceService;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesRequest;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchesResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxWithdrawAction
extends PayPlatformAction<WxWithdrawRequest> {
    private static final Logger log = LoggerFactory.getLogger(WxWithdrawAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private PaymentAccountBalanceService paymentAccountBalanceService;

    @Override
    public Message exec(WxWithdrawRequest request) {
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByAppIdAndMchId(request.getAppId(), request.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build((boolean)false).setMessage("\u63d0\u73b0\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        Boolean apiV3Enable = this.paymentConfigFacadeService.getApiV3Enable(request.getAccountId());
        if (Objects.equals(apiV3Enable, Boolean.TRUE)) {
            return this.apiV3Withdraw(wxPayService, request);
        }
        return this.apiV2Withdraw(wxPayService, request);
    }

    private Message apiV3Withdraw(WxPayService wxPayService, WxWithdrawRequest request) {
        ArrayList<TransferBatchesRequest.TransferDetail> transferDetailList = new ArrayList<TransferBatchesRequest.TransferDetail>();
        transferDetailList.add(TransferBatchesRequest.TransferDetail.newBuilder().openid(request.getIdentity()).outDetailNo(request.getRequestOrderNo()).transferAmount(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString())).transferRemark(request.getRemark()).build());
        TransferBatchesRequest transferBatchesRequest = new TransferBatchesRequest();
        transferBatchesRequest.setAppid(request.getAppId());
        transferBatchesRequest.setOutBatchNo(request.getRequestOrderNo());
        transferBatchesRequest.setBatchName(request.getRemark());
        transferBatchesRequest.setBatchRemark(request.getRemark());
        transferBatchesRequest.setTotalAmount(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        transferBatchesRequest.setTotalNum(Integer.valueOf(1));
        transferBatchesRequest.setTransferDetailList(transferDetailList);
        WithdrawResponse withdrawResponse = new WithdrawResponse();
        withdrawResponse.setRequestId(ThreadContext.getRequestId());
        withdrawResponse.setOutOrderNo(request.getOrderNo());
        withdrawResponse.setWithdrawOrderNo(request.getRequestOrderNo());
        withdrawResponse.setBatch(Boolean.TRUE);
        try {
            TransferBatchesResult transferBatchesResult = wxPayService.getTransferService().transferBatches(transferBatchesRequest);
            withdrawResponse.setResult(JSON.toJSONString((Object)transferBatchesResult));
            if (Objects.nonNull(transferBatchesResult.getBatchId())) {
                withdrawResponse.setThirdPartyOrderNo(transferBatchesResult.getBatchId());
                withdrawResponse.setSuccess(Boolean.valueOf(true));
                this.paymentAccountBalanceService.accountBalanceRemind(PlatformEnum.WX, request.getAccountId(), request.getAmount());
            } else {
                withdrawResponse.setSuccess(Boolean.valueOf(false));
                withdrawResponse.setErrorMsg("\u5fae\u4fe1\u6279\u91cf\u8f6c\u8d26\u5931\u8d25");
            }
        }
        catch (WxPayException e) {
            String errorMsg;
            String string = errorMsg = StringUtils.isBlank((CharSequence)e.getErrCodeDes()) ? e.getReturnMsg() : e.getErrCodeDes();
            if (Objects.equals(e.getErrCode(), "NOTENOUGH")) {
                this.paymentAccountBalanceService.accountArrearsRemind(PlatformEnum.WX, request.getAccountId(), request.getAmount());
            }
            WithdrawErrorTypeEnum withdrawErrorTypeEnum = WxErrorEnum.toErrorType(e.getErrCode());
            log.error("\u53d1\u8d77\u63d0\u73b0\u5931\u8d25:{}\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)e.getMessage(), (Object)request);
            withdrawResponse.setSuccess(Boolean.valueOf(false));
            withdrawResponse.setErrorMsg(errorMsg);
            withdrawResponse.setWithdrawErrorTypeEnum(withdrawErrorTypeEnum);
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)withdrawResponse);
    }

    private Message apiV2Withdraw(WxPayService wxPayService, WxWithdrawRequest request) {
        EntPayRequest entPayRequest = new EntPayRequest();
        entPayRequest.setAmount(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        entPayRequest.setAppid(request.getAppId());
        entPayRequest.setOpenid(request.getIdentity());
        entPayRequest.setCheckName("NO_CHECK");
        entPayRequest.setDescription(request.getRemark());
        entPayRequest.setPartnerTradeNo(request.getRequestOrderNo());
        entPayRequest.setSpbillCreateIp(request.getRequestIp());
        WithdrawResponse withdrawResponse = new WithdrawResponse();
        withdrawResponse.setRequestId(ThreadContext.getRequestId());
        withdrawResponse.setOutOrderNo(request.getOrderNo());
        withdrawResponse.setWithdrawOrderNo(request.getRequestOrderNo());
        try {
            EntPayResult result = wxPayService.getEntPayService().entPay(entPayRequest);
            withdrawResponse.setResult(JSON.toJSONString((Object)result));
            if (Objects.equals(result.getReturnCode(), "SUCCESS") && Objects.equals(result.getResultCode(), "SUCCESS")) {
                withdrawResponse.setSuccess(Boolean.valueOf(true));
                this.paymentAccountBalanceService.accountBalanceRemind(PlatformEnum.WX, request.getAccountId(), request.getAmount());
            } else {
                withdrawResponse.setSuccess(Boolean.valueOf(false));
                withdrawResponse.setErrorMsg(result.getReturnMsg());
            }
        }
        catch (WxPayException e) {
            String errorMsg;
            String string = errorMsg = StringUtils.isBlank((CharSequence)e.getErrCodeDes()) ? e.getReturnMsg() : e.getErrCodeDes();
            if (Objects.equals(e.getErrCode(), "NOTENOUGH")) {
                this.paymentAccountBalanceService.accountArrearsRemind(PlatformEnum.WX, request.getAccountId(), request.getAmount());
            }
            WithdrawErrorTypeEnum withdrawErrorTypeEnum = WxErrorEnum.toErrorType(e.getErrCode());
            log.error("\u53d1\u8d77\u63d0\u73b0\u5931\u8d25:{}\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)e.getMessage(), (Object)request);
            withdrawResponse.setSuccess(Boolean.valueOf(false));
            withdrawResponse.setErrorMsg(errorMsg);
            withdrawResponse.setWithdrawErrorTypeEnum(withdrawErrorTypeEnum);
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)withdrawResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}

