/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.cache;

import cn.hutool.core.date.SystemClock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.thirdparty.platform.cache.PaymentAccountRedisKey;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WxWithdrawLimitCache {
    @Resource
    private RedisListAdapter redisListAdapter;

    public boolean isPassQps(String accountId, Long timeValue, Integer count) {
        long timeMillis = SystemClock.now();
        Long size = this.redisListAdapter.size(this.builderKey(accountId));
        if (size < (long)count.intValue()) {
            return true;
        }
        Long first = (Long)this.redisListAdapter.leftPop(this.builderKey(accountId), Long.class);
        return first + timeValue < timeMillis;
    }

    private KeyGenerator builderKey(String accountId) {
        return PaymentAccountRedisKey.WX_WITHDRAW_QPS.copy().appendKey((Object)accountId);
    }

    public void addQps(String accountId) {
        long timeMillis = SystemClock.now();
        this.redisListAdapter.rightPush(this.builderKey(accountId), (Object[])new Long[]{timeMillis});
    }
}

