/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.liba;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.electric.liba.enums.LiBaStatusEnum;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.LiBaCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class LiBaCallbackAction
implements IPlatformCallbackAction {
    @Resource
    private ElectricLogMapper electricLogMapper;

    @Override
    public Class<?> support() {
        return LiBaCallbackParam.class;
    }

    public Message execCallback(PlatformCallbackContext context) {
        LiBaCallbackParam liBaCallbackParam = (LiBaCallbackParam)context.getCallbackParam();
        ElectricLogEntity orderInfo = (ElectricLogEntity)context.getOrderInfo();
        LiBaStatusEnum liBaStatusEnum = Objects.equals(liBaCallbackParam.getStatus(), "SUCCESS") ? LiBaStatusEnum.SUCCESS : LiBaStatusEnum.FAIL;
        ElectricLogEntity updateClass = new ElectricLogEntity();
        updateClass.setId(orderInfo.getId());
        updateClass.setStatus(liBaStatusEnum.getStatus());
        updateClass.setModifyTime(new Date());
        updateClass.setThirdPartyOrderNo(liBaCallbackParam.getNumber());
        updateClass.setErrorMsg(liBaCallbackParam.getRemarks());
        this.electricLogMapper.updateById((Object)updateClass);
        ElectricNotifyResponse response = new ElectricNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals((Object)liBaStatusEnum, (Object)LiBaStatusEnum.SUCCESS)) {
            response.setSuccess(Boolean.valueOf(true));
            response.setThirdPartyOrderNo(liBaCallbackParam.getNumber());
        } else {
            response.setSuccess(Boolean.valueOf(false));
            response.setErrorMsg(liBaCallbackParam.getRemarks());
        }
        response.setOrderNo(orderInfo.getOrderNo());
        response.setOutOrderNo(orderInfo.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

