/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.payment.ali;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.AlipayPaymentCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AliPaymentCallbackAction
implements IPlatformCallbackAction<AlipayPaymentCallbackParam, PaymentOrderV2Entity> {
    private static final Logger log = LoggerFactory.getLogger(AliPaymentCallbackAction.class);
    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;
    @Resource
    private LedgerLogService ledgerLogService;

    @Override
    public Class<?> support() {
        return AlipayPaymentCallbackParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext<AlipayPaymentCallbackParam, PaymentOrderV2Entity> context) {
        boolean success;
        int status;
        AlipayPaymentCallbackParam param = context.getCallbackParam();
        PaymentOrderV2Entity paymentOrderV2Entity = context.getOrderInfo();
        if (!Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.WAIT.getCode()) && !Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.TIMEOUT.getCode())) {
            log.warn("\u8ba2\u5355\u72b6\u6001\u3010{}\u3011\u4e0d\u5bf9\uff0c\u5df2\u88ab\u5904\u7406,callback:{}", (Object)paymentOrderV2Entity.getStatus(), (Object)param);
            return Message.build((boolean)false).setMessage("\u56de\u8c03\u4fe1\u606f\u5df2\u5904\u7406");
        }
        if ("TRADE_SUCCESS".equals(param.getTradeStatus())) {
            status = PaymentOrderStatusEnum.SUCCESS.getCode();
            success = Boolean.TRUE;
            this.ledgerLogService.insertLedgerLog(LegerLogParam.builder().legerTypeEnum(LegerTypeEnum.PAY).payPlatform(paymentOrderV2Entity.getPayPlatform()).accountId(paymentOrderV2Entity.getAccountId()).amount(paymentOrderV2Entity.getAmount()).build());
        } else {
            status = PaymentOrderStatusEnum.FAIL.getCode();
            success = Boolean.FALSE;
        }
        PaymentOrderV2Entity updateClass = new PaymentOrderV2Entity();
        updateClass.setId(paymentOrderV2Entity.getId());
        updateClass.setStatus(Integer.valueOf(status));
        updateClass.setThirdPartyTradeNo(param.getTradeNo());
        this.paymentOrderV2Mapper.updateById((Object)updateClass);
        PaymentNotifyResponse response = new PaymentNotifyResponse();
        response.setSuccess(Boolean.valueOf(success));
        response.setOrderNo(paymentOrderV2Entity.getOrderNo());
        response.setOutOrderNo(paymentOrderV2Entity.getOutOrderNo());
        response.setRequestId(context.getRequestId());
        response.setThirdPartyOrderNo(param.getTradeNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

