/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.payment.wx;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.WxPaymentCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxPaymentCallbackAction
implements IPlatformCallbackAction {
    private static final Logger log = LoggerFactory.getLogger(WxPaymentCallbackAction.class);
    private final PaymentConfigFacadeService paymentConfigFacadeService;
    private final PaymentOrderV2Mapper paymentOrderV2Mapper;
    private final LedgerLogService ledgerLogService;

    @Override
    public Class<?> support() {
        return WxPaymentCallbackParam.class;
    }

    public Message execCallback(PlatformCallbackContext context) {
        WxPaymentCallbackParam param = (WxPaymentCallbackParam)context.getCallbackParam();
        log.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\uff1a{}", (Object)param);
        PaymentOrderV2Entity paymentOrderV2Entity = (PaymentOrderV2Entity)context.getOrderInfo();
        if (!Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.WAIT.getCode()) && !Objects.equals(paymentOrderV2Entity.getStatus(), PaymentOrderStatusEnum.TIMEOUT.getCode())) {
            log.warn("\u8ba2\u5355\u72b6\u6001\u3010{}\u3011\u4e0d\u5bf9\uff0c\u5df2\u88ab\u5904\u7406,callback:{}", (Object)paymentOrderV2Entity.getStatus(), (Object)param);
            return Message.build((boolean)false).setMessage("\u56de\u8c03\u4fe1\u606f\u5df2\u5904\u7406");
        }
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByAppIdAndMchId(paymentOrderV2Entity.getAppId(), param.getMchId());
        if (Objects.isNull(wxPayService)) {
            log.error("\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JSON.toJSONString((Object)context));
            return Message.build((boolean)false);
        }
        boolean success = false;
        try {
            int status;
            WxPayOrderNotifyResult notifyResult = wxPayService.parseOrderNotifyResult(param.getXmlData());
            if (Objects.isNull(notifyResult)) {
                log.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)param));
                return Message.build((boolean)false);
            }
            if (Objects.equals(notifyResult.getReturnCode(), "SUCCESS") && Objects.equals(notifyResult.getResultCode(), "SUCCESS")) {
                success = true;
                status = PaymentOrderStatusEnum.SUCCESS.getCode();
                this.ledgerLogService.insertLedgerLog(LegerLogParam.builder().legerTypeEnum(LegerTypeEnum.PAY).payPlatform(paymentOrderV2Entity.getPayPlatform()).accountId(paymentOrderV2Entity.getAccountId()).amount(paymentOrderV2Entity.getAmount()).build());
            } else {
                status = PaymentOrderStatusEnum.FAIL.getCode();
            }
            PaymentOrderV2Entity updateClass = new PaymentOrderV2Entity();
            updateClass.setId(paymentOrderV2Entity.getId());
            updateClass.setStatus(Integer.valueOf(status));
            updateClass.setThirdPartyTradeNo(notifyResult.getTransactionId());
            this.paymentOrderV2Mapper.updateById((Object)updateClass);
            PaymentNotifyResponse response = new PaymentNotifyResponse();
            response.setRequestId(context.getRequestId());
            response.setSuccess(Boolean.valueOf(success));
            response.setErrorMsg(notifyResult.getReturnMsg());
            response.setOrderNo(paymentOrderV2Entity.getOrderNo());
            response.setOutOrderNo(paymentOrderV2Entity.getOutOrderNo());
            response.setThirdPartyOrderNo(notifyResult.getTransactionId());
            return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u652f\u4ed8\u7ed3\u679c\u65e0\u6cd5\u89e3\u6790\u4e3a\u5bf9\u5e94\u7684\u683c\u5f0f,\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)param);
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u7ed3\u679c\u65e0\u6cd5\u89e3\u6790\u4e3a\u5bf9\u5e94\u7684\u683c\u5f0f");
        }
    }

    public WxPaymentCallbackAction(PaymentConfigFacadeService paymentConfigFacadeService, PaymentOrderV2Mapper paymentOrderV2Mapper, LedgerLogService ledgerLogService) {
        this.paymentConfigFacadeService = paymentConfigFacadeService;
        this.paymentOrderV2Mapper = paymentOrderV2Mapper;
        this.ledgerLogService = ledgerLogService;
    }
}

