/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.enums;

import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import java.util.ArrayList;
import java.util.List;

public enum PlatformEnum {
    ALI(PlatformBusinessTypeEnum.PAYMENT),
    WX(PlatformBusinessTypeEnum.PAYMENT),
    UMS(PlatformBusinessTypeEnum.PAYMENT),
    XIN_RONG(PlatformBusinessTypeEnum.CHARGE_PHONE),
    GONG_MAO_CHARGE_PHONE(PlatformBusinessTypeEnum.CHARGE_PHONE),
    LI_BA(PlatformBusinessTypeEnum.ELECTRIC),
    GONG_MAO_ELECTRIC(PlatformBusinessTypeEnum.ELECTRIC);

    private PlatformBusinessTypeEnum businessTypeEnum;

    private PlatformEnum(PlatformBusinessTypeEnum businessTypeEnum) {
        this.businessTypeEnum = businessTypeEnum;
    }

    public static List<String> getPlatformListByBusinessType(PlatformBusinessTypeEnum typeEnum) {
        ArrayList<String> platformList = new ArrayList<String>();
        for (PlatformEnum value : PlatformEnum.values()) {
            if (!value.getBusinessTypeEnum().equals((Object)typeEnum)) continue;
            platformList.add(value.name());
        }
        return platformList;
    }

    public static PlatformEnum get(String platform) {
        for (PlatformEnum value : PlatformEnum.values()) {
            if (!value.name().equals(platform)) continue;
            return value;
        }
        return null;
    }

    public PlatformBusinessTypeEnum getBusinessTypeEnum() {
        return this.businessTypeEnum;
    }
}

