/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.interceptor;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.interceptor.IThirdPartyInterceptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IInterceptorExecutor {
    private static final Logger log = LoggerFactory.getLogger(IInterceptorExecutor.class);
    private Map<String, IThirdPartyInterceptor> interceptorMap = new HashMap<String, IThirdPartyInterceptor>();

    public IInterceptorExecutor(List<IThirdPartyInterceptor> interceptors) {
        for (IThirdPartyInterceptor interceptor : interceptors) {
            this.interceptorMap.put(interceptor.getClass().getSimpleName(), interceptor);
        }
    }

    public <T extends BaseRequest> Message accept(Class<? extends IThirdPartyInterceptor> interceptorClass, T t) {
        IThirdPartyInterceptor iThirdPartyInterceptor = this.interceptorMap.get(interceptorClass.getSimpleName());
        if (iThirdPartyInterceptor == null) {
            log.error("\u5b9a\u4e49\u7684\u62e6\u622a\u5668[{}]\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6ce8\u518c\u5230spring\u4e0a\u4e0b\u6587", (Object)iThirdPartyInterceptor);
            return Message.build((boolean)true);
        }
        return iThirdPartyInterceptor.accept(t);
    }
}

