/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.interceptor;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.cache.WxWithdrawLimitCache;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.interceptor.IThirdPartyInterceptor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxWithdrawCurrentLimiterInterceptor
implements IThirdPartyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WxWithdrawCurrentLimiterInterceptor.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;
    @Resource
    WxWithdrawLimitCache wxWithdrawLimitCache;

    @Override
    public <T extends BaseRequest> Message accept(T t) {
        WithdrawRequest withdrawRequest = (WithdrawRequest)t;
        if (!Objects.equals(withdrawRequest.getPayPlatform(), PlatformEnum.WX.name())) {
            return Message.build();
        }
        Boolean apiV3Enable = this.paymentConfigFacadeService.getApiV3Enable(withdrawRequest.getAccountId());
        if (apiV3Enable.booleanValue()) {
            long timeValue = TimeUnit.SECONDS.toMillis(1L);
            boolean passQps = this.wxWithdrawLimitCache.isPassQps(withdrawRequest.getAccountId(), timeValue, this.thirdPartyConfigProperties.getWxV3WithdrawQps());
            if (!passQps) {
                log.error("qps\u9650\u6d41\u4e86\uff1a{}", t);
                return Message.build((boolean)false).setMessage("\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            log.info("qps\u901a\u8fc7\uff1a{}", t);
        }
        return Message.build();
    }
}

