/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.queue.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.thirdparty.platform.config.ServerNotifyProperties;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.mapper.BusinessNotifyLogMapper;
import com.bxm.thirdparty.platform.model.entity.BusinessNotifyLogEntity;
import com.bxm.thirdparty.platform.queue.NotifyQueueCacheHolder;
import com.bxm.thirdparty.platform.queue.NotifyQueueExecutor;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.NotifyStatusEnum;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueueServiceImpl
implements QueueService {
    private static final Logger log = LoggerFactory.getLogger(QueueServiceImpl.class);
    private final BusinessNotifyLogMapper businessNotifyLogMapper;
    private final ApplicationRelationService applicationRelationService;
    private final SequenceCreater sequenceCreater;
    private final ServerNotifyProperties properties;
    private final ThirdPartyConfigProperties thirdPartyConfigProperties;
    private final NotifyQueueCacheHolder queueCacheHolder;
    private final NotifyQueueExecutor notifyQueueExecutor;
    private final NotifyMessageSender notifyMessageSender;

    @Override
    public void submitBusinessNotify(QueueBO queueBO) {
        Date nextNotifyTime;
        BusinessNotifyLogEntity businessNotifyLogEntity = this.businessNotifyLogMapper.getByRequestId(queueBO.getRequestId());
        if (Objects.nonNull(businessNotifyLogEntity)) {
            log.info("\u8be5\u901a\u77e5\u5df2\u63d0\u4ea4\u5230\u961f\u5217\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)queueBO));
            return;
        }
        if (queueBO.getNotifyUrl() == null) {
            String notifyUrl = this.applicationRelationService.getNotifyUrl(queueBO.getApplicationName());
            queueBO.setNotifyUrl(notifyUrl);
        }
        Long notifyId = this.sequenceCreater.nextLongId();
        int status = NotifyStatusEnum.WAIT_ING.getStatus();
        if (queueBO.getDelayTime() != null && queueBO.getDelayTime() > 0) {
            DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)queueBO.getDelayTime());
            nextNotifyTime = offset.toJdkDate();
        } else {
            nextNotifyTime = new Date();
            if (this.notifyQueueExecutor.isFullLoad()) {
                this.queueCacheHolder.addToQueue(queueBO);
            } else {
                this.notifyQueueExecutor.executor(queueBO);
            }
            status = NotifyStatusEnum.QUEUE_ING.getStatus();
        }
        BusinessNotifyLogEntity insertClass = new BusinessNotifyLogEntity();
        insertClass.setId(notifyId);
        insertClass.setRequestId(queueBO.getRequestId());
        insertClass.setRequest(JSON.toJSONString((Object)queueBO));
        insertClass.setFailNum(Integer.valueOf(0));
        insertClass.setCreateTime(new Date());
        insertClass.setNextNotifyTime(nextNotifyTime);
        insertClass.setStatus(Integer.valueOf(status));
        insertClass.setType(queueBO.getRequestBodyBO().getType());
        this.businessNotifyLogMapper.insert((Object)insertClass);
    }

    @Override
    public void addBusinessFailInfo(QueueBO queueBO, String errorMsg) {
        BusinessNotifyLogEntity businessNotifyLogEntity = this.businessNotifyLogMapper.getByRequestId(queueBO.getRequestId());
        if (Objects.isNull(businessNotifyLogEntity)) {
            int nextInterval = this.properties.getRetryIntervalArray()[1];
            DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)nextInterval);
            businessNotifyLogEntity = new BusinessNotifyLogEntity();
            businessNotifyLogEntity.setId(this.sequenceCreater.nextLongId());
            businessNotifyLogEntity.setRequest(JSON.toJSONString((Object)queueBO));
            businessNotifyLogEntity.setRequestId(queueBO.getRequestId());
            businessNotifyLogEntity.setFailNum(Integer.valueOf(0));
            businessNotifyLogEntity.setType(queueBO.getRequestBodyBO().getType());
            businessNotifyLogEntity.setCreateTime(new Date());
            businessNotifyLogEntity.setNextNotifyTime(offset.toJdkDate());
            businessNotifyLogEntity.setStatus(Integer.valueOf(NotifyStatusEnum.WAIT_ING.getStatus()));
            this.businessNotifyLogMapper.insert((Object)businessNotifyLogEntity);
        } else {
            if (businessNotifyLogEntity.getFailNum() + 1 >= this.properties.getRetryIntervalArray().length) {
                log.error("\u4e1a\u52a1\u901a\u77e5[{}]\u91cd\u8bd5\u6b21\u6570\u8fbe\u5230[{}]\u6b21\uff0crequestId:{},\u76f4\u63a5\u8bb0\u5f55\u4e3a\u5931\u8d25,\u6700\u8fd1\u4e00\u6b21\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", new Object[]{businessNotifyLogEntity.getId(), businessNotifyLogEntity.getFailNum(), businessNotifyLogEntity.getRequestId(), errorMsg});
                this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u7b2c\u4e09\u65b9\u4e1a\u52a1\u901a\u77e5")).content("\u7b2c\u4e09\u65b9\u4e1a\u52a1\u901a\u77e5\uff1a" + queueBO.getApplicationName() + " \u670d\u52a1\u5931\u8d25\n\u7c7b\u578b" + businessNotifyLogEntity.getType() + "\n\u6700\u540e\u4e00\u6b21\u5931\u8d25\u8fd4\u56de\u4fe1\u606f\uff1a" + errorMsg + "\nrequestId:" + businessNotifyLogEntity.getRequestId())).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
                return;
            }
            Long id = businessNotifyLogEntity.getId();
            Integer failNum = businessNotifyLogEntity.getFailNum() + 1;
            int nextInterval = this.properties.getRetryIntervalArray()[businessNotifyLogEntity.getFailNum()];
            DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)nextInterval);
            businessNotifyLogEntity = new BusinessNotifyLogEntity();
            businessNotifyLogEntity.setNextNotifyTime(offset.toJdkDate());
            businessNotifyLogEntity.setId(id);
            businessNotifyLogEntity.setStatus(Integer.valueOf(NotifyStatusEnum.WAIT_ING.getStatus()));
            businessNotifyLogEntity.setFailNum(failNum);
            businessNotifyLogEntity.setModifyTime(new Date());
            businessNotifyLogEntity.setRemark(errorMsg);
            this.businessNotifyLogMapper.updateById((Object)businessNotifyLogEntity);
        }
    }

    @Override
    public void updateNotifyInfoSuccess(String requestId) {
        BusinessNotifyLogEntity businessNotifyLogEntity = this.businessNotifyLogMapper.getByRequestId(requestId);
        if (Objects.isNull(businessNotifyLogEntity)) {
            log.error("\u4e1a\u52a1\u901a\u77e5[{}]\u6210\u529f\uff0c\u4f46\u672a\u67e5\u8be2\u5230\u901a\u77e5\u4fe1\u606f", (Object)requestId);
            return;
        }
        BusinessNotifyLogEntity updateClass = new BusinessNotifyLogEntity();
        updateClass.setId(businessNotifyLogEntity.getId());
        updateClass.setStatus(Integer.valueOf(NotifyStatusEnum.SUCCESS.getStatus()));
        updateClass.setModifyTime(new Date());
        this.businessNotifyLogMapper.updateById((Object)updateClass);
    }

    public QueueServiceImpl(BusinessNotifyLogMapper businessNotifyLogMapper, ApplicationRelationService applicationRelationService, SequenceCreater sequenceCreater, ServerNotifyProperties properties, ThirdPartyConfigProperties thirdPartyConfigProperties, NotifyQueueCacheHolder queueCacheHolder, NotifyQueueExecutor notifyQueueExecutor, NotifyMessageSender notifyMessageSender) {
        this.businessNotifyLogMapper = businessNotifyLogMapper;
        this.applicationRelationService = applicationRelationService;
        this.sequenceCreater = sequenceCreater;
        this.properties = properties;
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
        this.queueCacheHolder = queueCacheHolder;
        this.notifyQueueExecutor = notifyQueueExecutor;
        this.notifyMessageSender = notifyMessageSender;
    }
}

