/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.queue.notifybusiness.defaults;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.thirdparty.platform.context.FailInfoContext;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.queue.notifybusiness.INotifyBusinessAction;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.QueueEnum;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IDefaultAction
implements INotifyBusinessAction {
    private static final Logger log = LoggerFactory.getLogger(IDefaultAction.class);

    private QueueService getQueueService() {
        return (QueueService)SpringContextHolder.getBean(QueueService.class);
    }

    @Override
    public String type() {
        return QueueEnum.DEFAULT.name();
    }

    @Override
    public void notifyBusiness(QueueBO queueBO) {
        String errorMsg;
        HttpRequest httpRequest = HttpUtil.createPost((String)queueBO.getNotifyUrl());
        RequestBodyBO requestBodyBO = queueBO.getRequestBodyBO();
        httpRequest.body(JSON.toJSONString((Object)requestBodyBO));
        httpRequest.contentType("application/json");
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
            log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{},\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)execute.body(), (Object)JSON.toJSONString((Object)queueBO));
            if (execute.isOk() && Objects.equals(execute.body(), "SUCCESS")) {
                log.info("\u56de\u8c03\u4e1a\u52a1\u65b9\u6210\u529f\uff1a{}", (Object)queueBO);
                this.getQueueService().updateNotifyInfoSuccess(queueBO.getRequestId());
                return;
            }
            errorMsg = "\u56de\u8c03\u4e1a\u52a1\u65b9\u5931\u8d25\uff0c\u672a\u8fd4\u56de\u9884\u671f\u7684\u503c" + execute.getStatus();
            log.warn("\u56de\u8c03\u4e1a\u52a1\u65b9\u5931\u8d25\uff1a{}", (Object)queueBO);
        }
        catch (Exception e) {
            log.error("\u56de\u8c03\u4e1a\u52a1\u65b9\u670d\u52a1500\uff1a{}", (Object)queueBO, (Object)e);
            errorMsg = "\u56de\u8c03\u4e1a\u52a1\u65b9\u670d\u52a1\u5931\u8d25" + e.getMessage();
        }
        FailInfoContext failInfoContext = new FailInfoContext();
        failInfoContext.setErrorMsg(errorMsg);
        failInfoContext.setRequestId(queueBO.getRequestId());
        failInfoContext.setRequest(JSON.toJSONString((Object)queueBO));
        this.getQueueService().addBusinessFailInfo(queueBO, errorMsg);
    }
}

