/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.thirdparty.platform.cache.PaymentAccountRedisKey;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.service.PaymentAccountBalanceService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PaymentAccountBalanceServiceImpl
implements PaymentAccountBalanceService {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountBalanceServiceImpl.class);
    private final ThirdPartyConfigProperties thirdPartyConfigProperties;
    private final RedisStringAdapter redisStringAdapter;
    private final NotifyMessageSender notifyMessageSender;

    @Override
    public void addMoney(String accountId, BigDecimal money) {
        BigDecimal multiply = money.multiply(BigDecimal.valueOf(100L));
        KeyGenerator keyGenerator = PaymentAccountRedisKey.ACCOUNT_BALANCE.copy().appendKey((Object)accountId);
        this.redisStringAdapter.increment(keyGenerator, multiply.doubleValue());
    }

    @Override
    @Async
    public void accountBalanceRemind(PlatformEnum platformEnum, String accountId, BigDecimal amount) {
        KeyGenerator keyGenerator = PaymentAccountRedisKey.ACCOUNT_BALANCE.copy().appendKey((Object)accountId);
        int expandMoney = amount.multiply(new BigDecimal(100)).intValue();
        Long balance = this.redisStringAdapter.increment(keyGenerator, -expandMoney);
        List<String> accountMoneyRemindStage = this.thirdPartyConfigProperties.getAccountMoneyRemindStage();
        KeyGenerator remindStage = PaymentAccountRedisKey.ACCOUNT_BALANCE_REMIND_STAGE.copy().appendKey((Object)accountId);
        String finalStage = null;
        for (String stage : accountMoneyRemindStage) {
            String[] moneyRange = stage.split("-");
            String maxValue = moneyRange[0];
            String minValue = moneyRange[1];
            boolean balanceStage = Long.parseLong(minValue) <= balance / 100L && Long.parseLong(maxValue) >= balance / 100L;
            if (!balanceStage) continue;
            finalStage = stage;
            break;
        }
        if (Objects.isNull(finalStage)) {
            return;
        }
        String currStage = (String)this.redisStringAdapter.get(remindStage, String.class);
        if (Objects.equals(finalStage, currStage)) {
            log.info("\u5f53\u524d\u9636\u6bb5\u5df2\u63d0\u9192\uff0c\u4e0d\u518d\u63d0\u9192\uff1a{}\uff0crequest\uff1a{},balance\u5927\u81f4\u4e3a:{}", new Object[]{currStage, accountId, balance / 100L});
            return;
        }
        this.redisStringAdapter.set(remindStage, finalStage);
        this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u8d26\u6237\u4f59\u989d\u63d0\u9192")).content("\u8d26\u6237\u4f59\u989d\u63d0\u9192:\u5e73\u53f0" + platformEnum.name() + "\n\u5546\u6237\u53f7:" + accountId + "\n\u5f53\u524d\u8d26\u6237\u4f59\u989d\uff1a" + balance / 100L + "\n\u5df2\u8fbe\u5230\u3010" + finalStage + "\u3011\u9636\u6bb5\uff0c\n\u8bf7\u6ce8\u610f\uff01\uff01")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
    }

    @Override
    @Async
    public void accountArrearsRemind(PlatformEnum platformEnum, String account, BigDecimal amount) {
        this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u6b20\u8d39\u63d0\u9192")).content("\u6b20\u8d39\u63d0\u9192:\u5e73\u53f0:" + platformEnum.name() + "\n\u8d26\u6237\uff1a" + account + "\n\u5df2\u6b20\u8d39\uff0c\u8bf7\u63d0\u9192\u8fd0\u8425\u5145\u503c\uff01\uff01\uff01\u5145\u503c\u5b8c\u6210\u540e\uff0c\u8bf7\u8c03\u7528" + this.thirdPartyConfigProperties.getServerUrl() + this.thirdPartyConfigProperties.getPaymentAccountRecharge() + "?accountId={\u5546\u6237id}&money={\u5145\u503c\u7684\u91d1\u989d}\uff0c\u6062\u590d\u76d1\u63a7\u4f59\u989d\u4fe1\u606f")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
    }

    public PaymentAccountBalanceServiceImpl(ThirdPartyConfigProperties thirdPartyConfigProperties, RedisStringAdapter redisStringAdapter, NotifyMessageSender notifyMessageSender) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.notifyMessageSender = notifyMessageSender;
    }
}

