/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.response.PhoneIspDTO;
import com.bxm.thirdparty.platform.mapper.PhoneAnalysisMapper;
import com.bxm.thirdparty.platform.model.entity.PhoneAnalysisEntity;
import com.bxm.thirdparty.platform.service.PhoneIspService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PhoneIspServiceImpl
implements PhoneIspService {
    private static final Logger log = LoggerFactory.getLogger(PhoneIspServiceImpl.class);
    private final PhoneAnalysisMapper phoneAnalysisMapper;

    @Override
    public Message getPhoneIsp(String phone) {
        if (!NumberUtil.isNumber((CharSequence)phone) || phone.length() < 11) {
            return Message.build((boolean)false).setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
        }
        String substring = phone.substring(0, 7);
        PhoneAnalysisEntity phoneIspInfo = this.phoneAnalysisMapper.getPhoneIspInfo(substring);
        if (phoneIspInfo == null) {
            return Message.build((boolean)false).setMessage("\u6682\u4e0d\u652f\u6301\u7684\u8fd0\u8425\u5546");
        }
        if (phoneIspInfo.getEnable() == 0) {
            return Message.build((boolean)false).setMessage("\u6682\u4e0d\u652f\u6301\u7684\u8fd0\u8425\u5546");
        }
        PhoneIspDTO phoneIspDTO = new PhoneIspDTO();
        phoneIspDTO.setCity(phoneIspInfo.getCity());
        phoneIspDTO.setProvince(phoneIspInfo.getProvince());
        phoneIspDTO.setIsp(phoneIspInfo.getIsp());
        phoneIspDTO.setPhone(phone);
        phoneIspDTO.setSuccess(Boolean.valueOf(true));
        phoneIspDTO.setRequestId(ThreadContext.getRequestId());
        return Message.build((boolean)true).addParam(CommonConstant.RESULT_DTO, (Object)phoneIspDTO);
    }

    public PhoneIspServiceImpl(PhoneAnalysisMapper phoneAnalysisMapper) {
        this.phoneAnalysisMapper = phoneAnalysisMapper;
    }
}

