/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.enums.BatchWithdrawErrorEnum;
import com.bxm.thirdparty.platform.enums.PaymentWithdrawStatusEnum;
import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.WithdrawNotifyResponse;
import com.bxm.thirdparty.platform.mapper.PaymentWithdrawFlowV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import com.bxm.thirdparty.platform.service.PaymentService;
import com.github.binarywang.wxpay.bean.transfer.QueryTransferBatchesRequest;
import com.github.binarywang.wxpay.bean.transfer.QueryTransferBatchesResult;
import com.github.binarywang.wxpay.bean.transfer.TransferBatchDetailResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BatchWithdrawResultTask
extends AbstractCronXxlJob {
    private static final Logger log = LoggerFactory.getLogger(BatchWithdrawResultTask.class);
    @Resource
    private PaymentWithdrawFlowV2Mapper paymentWithdrawFlowV2Mapper;
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private QueueService queueService;
    @Resource
    private PaymentService paymentService;
    @Resource
    private LedgerLogService ledgerLogService;
    private static final String SUCCESS = "SUCCESS";
    private static final String FAIL = "FAIL";

    public void executeLogic() {
        List handlerIngOrder = this.paymentWithdrawFlowV2Mapper.getHandlerIngOrder(Integer.valueOf(PaymentWithdrawStatusEnum.HANDLER_ING.getCode()));
        for (PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity : handlerIngOrder) {
            WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByAppIdAndMchId(paymentWithdrawFlowV2Entity.getAppId(), paymentWithdrawFlowV2Entity.getAccountId());
            QueryTransferBatchesRequest requestBuilder = new QueryTransferBatchesRequest();
            requestBuilder.setOutBatchNo(paymentWithdrawFlowV2Entity.getWithdrawOrderNo());
            requestBuilder.setNeedQueryDetail(Boolean.TRUE);
            requestBuilder.setDetailStatus("ALL");
            requestBuilder.setOffset(Integer.valueOf(0));
            requestBuilder.setLimit(Integer.valueOf(20));
            try {
                QueryTransferBatchesResult queryTransferBatchesResult = wxPayService.getTransferService().transferBatchesOutBatchNo(requestBuilder);
                String batchId = queryTransferBatchesResult.getTransferBatch().getBatchId();
                List transferDetailList = queryTransferBatchesResult.getTransferDetailList();
                for (QueryTransferBatchesResult.TransferDetail transferDetail : transferDetailList) {
                    String detailStatus = transferDetail.getDetailStatus();
                    if (Objects.equals(detailStatus, SUCCESS)) {
                        this.paymentService.updateWithdrawOrderSuccess(transferDetail.getOutDetailNo());
                        this.ledgerLogService.insertLedgerLog(LegerLogParam.builder().legerTypeEnum(LegerTypeEnum.WITHDRAW).payPlatform(paymentWithdrawFlowV2Entity.getPayPlatform()).accountId(paymentWithdrawFlowV2Entity.getAccountId()).amount(paymentWithdrawFlowV2Entity.getAmount()).build());
                        this.businessSubmit(paymentWithdrawFlowV2Entity, true, null, batchId);
                    }
                    if (!Objects.equals(detailStatus, FAIL)) continue;
                    TransferBatchDetailResult transferBatchDetailResult = wxPayService.getTransferService().transferBatchesBatchIdDetail(batchId, transferDetail.getDetailId());
                    String failReason = transferBatchDetailResult.getFailReason();
                    BatchWithdrawErrorEnum of = BatchWithdrawErrorEnum.of(failReason);
                    this.paymentService.updateWithdrawOrderFail(transferDetail.getOutDetailNo(), of.getDesc());
                    this.businessSubmit(paymentWithdrawFlowV2Entity, false, of.getDesc(), batchId);
                }
            }
            catch (WxPayException e) {
                log.error("\u67e5\u8be2\u6279\u91cf\u8f6c\u8d26\u8bb0\u5f55\u5931\u8d25\uff1a{}", (Object)paymentWithdrawFlowV2Entity, (Object)e);
            }
        }
    }

    private void businessSubmit(PaymentWithdrawFlowV2Entity orderInfo, Boolean success, String errorMsg, String batchId) {
        WithdrawNotifyResponse withdrawNotifyResponse = new WithdrawNotifyResponse();
        withdrawNotifyResponse.setSuccess(success);
        withdrawNotifyResponse.setErrorMsg(errorMsg);
        withdrawNotifyResponse.setRequestId(orderInfo.getRequestId());
        withdrawNotifyResponse.setOrderNo(orderInfo.getWithdrawOrderNo());
        withdrawNotifyResponse.setOutOrderNo(orderInfo.getOutTrackNo());
        withdrawNotifyResponse.setAccountId(orderInfo.getAccountId());
        withdrawNotifyResponse.setPayPlatform(orderInfo.getPayPlatform());
        withdrawNotifyResponse.setThirdPartyOrderNo(batchId);
        QueueBO queueBO = new QueueBO();
        queueBO.setApplicationName(orderInfo.getApplicationName());
        queueBO.setRequestId(orderInfo.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(NotifyTypeEnum.WITHDRAW.name()).result(JSON.toJSONString((Object)withdrawNotifyResponse)).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    protected String cron() {
        return "0/10 * * * * ?";
    }

    public String jobDesc() {
        return "\u6267\u884c\u4e1a\u52a1\u901a\u77e5";
    }

    public String author() {
        return "lowi";
    }
}

