/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoBalanceBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoResultBO;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GongMaoUtil {
    private static final Logger log = LoggerFactory.getLogger(GongMaoUtil.class);
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public GongMaoUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }

    public String submitOrder(Map<String, Object> paramMap) {
        paramMap.put("sign", this.getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost((String)(this.thirdPartyConfigProperties.getGongMaoDomain() + this.thirdPartyConfigProperties.getGongMaoSubmitOrderUrl()));
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(paramMap);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        }
        catch (Exception e) {
            log.error("\u5de5\u732b\u63d0\u4ea4\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u6c42\u4f53\uff1a{},error:", (Object)JSON.toJSONString(paramMap), (Object)e);
            return null;
        }
        log.info("\u5de5\u732b\u63d0\u4ea4\u5145\u503c\u8ba2\u5355\uff0c\u8bf7\u6c42\u4f53\uff1a{},result:{}", (Object)JSON.toJSONString(paramMap), (Object)execute.body());
        if (execute.isOk()) {
            return execute.body();
        }
        return null;
    }

    public GongMaoBalanceBO getBalance() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sign", this.getSign(params));
        HttpRequest httpRequest = HttpUtil.createPost((String)(this.thirdPartyConfigProperties.getGongMaoDomain() + this.thirdPartyConfigProperties.getGongMaoBalanceUrl()));
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(params);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        }
        catch (Exception e) {
            log.error("\u5de5\u732b\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u8bf7\u6c42\u4f53\uff1a{},error:", (Object)JSON.toJSONString(params), (Object)e);
            return null;
        }
        log.info("\u5de5\u732b\u67e5\u8be2\u4f59\u989d\uff0c\u8bf7\u6c42\u4f53\uff1a{},result:{}", (Object)JSON.toJSONString(params), (Object)execute.body());
        if (execute.isOk()) {
            String body = execute.body();
            GongMaoResultBO gongMaoResultBO = (GongMaoResultBO)JSON.parseObject((String)body, GongMaoResultBO.class);
            if (gongMaoResultBO != null && gongMaoResultBO.getSuccess().booleanValue()) {
                return (GongMaoBalanceBO)JSON.parseObject((String)JSON.toJSONString((Object)gongMaoResultBO.getData()), GongMaoBalanceBO.class);
            }
            return null;
        }
        return null;
    }

    public String getProduct() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sign", this.getSign(params));
        HttpRequest httpRequest = HttpUtil.createPost((String)(this.thirdPartyConfigProperties.getGongMaoDomain() + "/api/sideline/agent/getProductList"));
        httpRequest.charset(CharsetUtil.CHARSET_UTF_8);
        httpRequest.form(params);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
        }
        catch (Exception e) {
            log.error("\u5de5\u732b\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42\u4f53\uff1a{},error:", (Object)JSON.toJSONString(params), (Object)e);
            return null;
        }
        log.info("\u5de5\u732b\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\uff0c\u8bf7\u6c42\u4f53\uff1a{},result:{}", (Object)JSON.toJSONString(params), (Object)execute.body());
        if (execute.isOk()) {
            return execute.body();
        }
        return null;
    }

    private String getSign(Map<String, Object> params) {
        params.put("appKey", this.thirdPartyConfigProperties.getGongMaoAppKey());
        params.put("nonce", RandomUtil.randomString((int)32));
        params.put("timestamp", DateUtil.current());
        Set<String> keyList = params.keySet();
        ArrayList<String> list = new ArrayList<String>(keyList);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String key : list) {
            sb.append(key).append("=").append(params.get(key)).append("&");
        }
        sb.append("appSecret=").append(this.thirdPartyConfigProperties.getGongMaoAppSecret());
        System.out.println("sign\u672a\u8f6cMD5 = " + sb.toString());
        return MD5Util.standardMd5((String)sb.toString()).toUpperCase();
    }
}

