/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.netflix.appinfo.EurekaInstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class ApolloConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ApolloConfiguration.class);
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private EurekaInstanceConfig instance;
    private static final String EUREKA_METADATA_PRE_KEY = "eureka.instance.metadata-map.env";

    @ApolloConfigChangeListener(value={"application", "LN.common", "LN.clientConfig"})
    public void changeHandler(ConfigChangeEvent configChangeEvent) {
        if (log.isDebugEnabled()) {
            for (String key : configChangeEvent.changedKeys()) {
                log.debug("change key : {}", (Object)key);
                if (!EUREKA_METADATA_PRE_KEY.equals(key) || null == this.instance) continue;
                String newValue = configChangeEvent.getChange(EUREKA_METADATA_PRE_KEY).getNewValue();
                log.debug("\u66f4\u65b0instance.metadata\uff1a{}", (Object)newValue);
                this.instance.getMetadataMap().put(EUREKA_METADATA_PRE_KEY, newValue);
            }
        }
        this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(configChangeEvent.changedKeys()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

