/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.apollo.i18n;

import com.bxm.newidea.component.apollo.i18n.MessageHelper;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;

@Component
public class ApolloMessageSource
extends AbstractMessageSource
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ApolloMessageSource.class);
    private Locale defaultLocale = Locale.CHINA;
    private final Object lock = new Object();
    private final ConfigPropertySourceFactory configPropertySourceFactory = (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private static final String I18N_NAMESPACE_PREFIX = "i18N";
    private Map<Locale, Map<String, MessageFormat>> cacheMessages = Maps.newHashMap();

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat message;
        Map<Object, Object> cacheMap = this.cacheMessages.get(locale);
        if (null == cacheMap) {
            cacheMap = Maps.newHashMap();
            String loadNameSpace = "i18N." + this.getLocaleSpace(locale);
            Config config = ConfigService.getConfig((String)loadNameSpace);
            if (null != config) {
                String[] propertyNames;
                ConfigPropertySource configPropertySource = this.configPropertySourceFactory.getConfigPropertySource(loadNameSpace, config);
                configPropertySource.addChangeListener(changeEvent -> this.refresh());
                for (String propertyName : propertyNames = configPropertySource.getPropertyNames()) {
                    String propertyValue = Objects.toString(configPropertySource.getProperty(propertyName));
                    cacheMap.put(propertyName, new MessageFormat(propertyValue, locale));
                }
            }
            this.cacheMessages.putIfAbsent(locale, cacheMap);
        }
        if (null != (message = (MessageFormat)cacheMap.get(code))) {
            return message;
        }
        cacheMap = this.cacheMessages.get(this.defaultLocale);
        if (null != cacheMap && null != (message = (MessageFormat)cacheMap.get(code))) {
            log.warn("\u7f16\u7801\uff1a{}\u672a\u5b9a\u4e49\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7684locale", (Object)code, (Object)locale.toString());
            return message;
        }
        log.warn("\u7f16\u7801\uff1a{}\u672a\u5b9a\u4e49\uff0c\u9ed8\u8ba4locale\u4e2d\u4e5f\u672a\u5b9a\u4e49", (Object)code, (Object)locale.toString());
        return null;
    }

    private String getLocaleSpace(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.cacheMessages = Maps.newHashMap();
        }
    }

    public void afterPropertiesSet() {
        MessageHelper.setMessageSource(this);
    }
}

