package com.bxm.localnews.auth.enums;

/**
 * 鉴权码枚举
 * @author liujia
 */
public enum  AuthCodeEnum {

    /**
     * 是否可以抢群聊中的红包
     */
    PICK_RED_PACKAGE(0),

    /**
     * 禁止在群聊中发言
     */
    BANNED_TO_POST(1),

    /**
     * 阶段禁言（禁言一小时、一天）
     */
    BANNED_PHASE(2),

    /**
     * 解除用户禁言
     */
    UNBANNED_TO_POST(3);

    /**
     * 权限位在权限编码中的bit位置
     * 从0开始，每64位新增一个group
     */
    int index;

    AuthCodeEnum(int index) {
        this.index = index;
    }
}
