package com.bxm.localnews.mq.common.constant;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * Created by Arei on 2018/10/12.
 * 此类用于标识阿里云MQ的Messgae的tag所对应所属的topic及相应的生产者消费者
 * 所有使用的tag都要在这里注册，有新的topicType需要修改Enum+AliMQService
 * @author arei
 */
public enum AliMqMsgTagEnum {
    /**
     * 短信tag
     */
    SMS("sms", "sms", "smsProducer"),

    /**
     * 推送消息tag
     */
    PUSH("push", "push", "pushProducer"),

    /**
     * 新闻推送消息-分享tag
     */
    SHARE("news", "share", "newsProducer"),

    /**
     * 新闻推送消息-浏览tag
     */
    VIEW("news", "view", "newsProducer"),

    /**
     * 新闻推送消息-推荐tag
     */
    RECOMMENDED("news", "recommended", "newsProducer"),

    /**
     * 新闻推送消息-点击tag
     */
    NEW_CLICK("news", "newClick", "newsProducer"),

    /**
     * 新闻推送消息-收藏tag
     */
    COLLECT("news", "collect", "newsProducer"),

    /**
     * 新闻推送消息-评论tag
     */
    COMMENT("news", "comment", "newsProducer"),

    VIDEO_BLACK("news", "video_black", "newsProducer"),

    VIDEO_SHARE("news", "video_share", "newsProducer"),

    VIDEO_VIEW("news", "video_view", "newsProducer"),

    VIDEO_COMMENT("news", "video_comment", "newsProducer"),
    USER_RECOMMEND_ATTRIBUTE("user_recommend", "attribute", "userRecommendProducer"),
    USER_RECOMMEND_BEHAVIOR("user_recommend", "behavior", "userRecommendProducer"),
    USER_RECOMMEND_POSITION("user_recommend", "position", "userRecommendProducer"),

    ;


    /**
     * aliMQ topic类型，用来帮助获取配置类中对应的topic
     */
    private String topicType;

    /**
     * aliMQ Messga中的tag，用来标识具体业务
     */
    private String tag;

    /**
     * aliMQ生产者ProducerBean类的具体实现类名（注册在SpringContext中具体组件名）
     */
    private String producerName;

    AliMqMsgTagEnum(String topicType, String tag, String producerName) {
        this.topicType = topicType;
        this.tag = tag;
        this.producerName = producerName;
    }

    /**
     * 判断tag是否已经注册在Enum中
     * @param tag
     * @return
     */
    public static Optional<AliMqMsgTagEnum> getTagEnumByTag(String tag) {
        return Stream.of(AliMqMsgTagEnum.values()).filter(tagEnum -> tag.equals(tagEnum.getTag())).findAny();
    }

    /**
     * 获取tag对应的topicType来获取实际的topic值
     * @param tag
     * @return
     */
    public static String getTopicTypeByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getTopicType();
        } else {
            return "";
        }
    }

    /**
     * 获取tag对应的生产者名来调用对应的实际生产者组件
     * @param tag
     * @return
     */
    public static String getProducerNameByTag(String tag) {
        Optional<AliMqMsgTagEnum> tagEnumOptional = getTagEnumByTag(tag);
        if (tagEnumOptional.isPresent()) {
            return tagEnumOptional.get().getProducerName();
        } else {
            return "producer";
        }
    }

    public String getProducerName() {
        return producerName;
    }

    public String getTopicType() {
        return topicType;
    }

    public String getTag() {
        return tag;
    }
}
