/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.common.handler;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.util.WebUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class CustomizeExceptionHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={BindException.class})
    public Json handleBindException(BindException e, HttpServletRequest request) {
        List errors = e.getBindingResult().getFieldErrors();
        Map<String, String> errorMap = errors.stream().collect(Collectors.toMap(FieldError::getField, DefaultMessageSourceResolvable::getDefaultMessage));
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build().setCode(RespCode.BAD_REQUEST).setResult(errorMap).setErrorMsg("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25").output();
    }

    @ExceptionHandler(value={BusinessException.class})
    public Json handleBusinessException(BusinessException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Json handleBusinessException(IllegalArgumentException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.BAD_REQUEST, e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Json handleBusinessException(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.METHOD_NOT_ALLOWED, e.getMessage());
    }

    protected void loginError(HttpServletRequest request) {
        this.logger.error("request uri:[{}],request param:[{}]", (Object)request.getRequestURI(), (Object)WebUtils.getReqeustParam((HttpServletRequest)request));
    }

    @ExceptionHandler(value={Exception.class})
    public Json handlException(Exception e, HttpServletRequest request) {
        this.loginError(request);
        this.logger.error(e.getMessage(), (Throwable)e);
        return Json.build(RespCode.INTERNAL_SERVER_ERROR, "\u670d\u52a1\u5668\u9519\u8bef");
    }
}

