package com.bxm.component.mq.conditionals;

import com.bxm.component.mq.config.MessageConfigurationProperties;
import com.bxm.component.mq.enums.MessageTypeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Map;

/**
 * 判断启用的message客户端 配合注解{@link com.bxm.component.mq.conditionals.MessageConditionalOnProperty}使用
 *
 * @author lowi
 * @date 2021/8/18 14:37
 */
@Slf4j
public class MessageListenerConditional implements Condition {

    private MessageConfigurationProperties messageConfigurationProperties = new MessageConfigurationProperties();

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map<String, Object> annotationAttributes = metadata.getAnnotationAttributes(MessageConditionalOnProperty.class.getName());
        MessageTypeEnum messageTypeEnum = (MessageTypeEnum) annotationAttributes.get("type");
        Environment environment = context.getEnvironment();
        String property = environment.getProperty("component.message.message-type");
        if (property == null) {
            property = messageConfigurationProperties.getMessageType();
        }
        return messageTypeEnum.name().equals(property);
    }
}
