package com.bxm.component.mq.message.listener.rabbit;

import com.bxm.component.mq.MessageConsumer;
import com.bxm.component.mq.conditionals.MessageConditionalOnProperty;
import com.bxm.component.mq.enums.MessageTypeEnum;
import com.bxm.newidea.component.JSON;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 具体的消费实现类，根据MessageConditionalOnProperty注解判断客户端是否创建bean
 *
 * @author lowi
 * @date 2021/8/3 17:11
 */
@Slf4j
@MessageConditionalOnProperty(type = MessageTypeEnum.RABBIT_MQ)
public class ConcreteRabbitConsumer<T> extends DefaultConsumer {

    private static Map<String, MessageConsumer> messageConsumerMaps = new HashMap<>();

    private static Map<String, Class<?>> classNameMaps = new HashMap<>();

    public ConcreteRabbitConsumer(Channel channel, MessageConsumer subscriber, Class<?> className, String exchange) {
        super(channel);
        //服务启动后 通过获取到实现MessageConsumer对象的类信息，保存到map里，key为交换机名称
        this.messageConsumerMaps.put(exchange, subscriber);
        //服务启动后 通过获取到实现MessageConsumer对象的 返回指定的类 信息，保存到map里，key为交换机名称
        this.classNameMaps.put(exchange, className);
    }


    /**
     * rabbitmq默认的监听实现方法
     */
    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        //发送到具体实现了MessageConsumer类的方法
        MessageConsumer messageConsumer = messageConsumerMaps.get(envelope.getExchange());
        Class<?> className = classNameMaps.get(envelope.getExchange());
        messageConsumer.consumer(JSON.parseObject(new String(body), className));
    }
}
