/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mq.conditionals;

import com.bxm.component.mq.conditionals.MessageConditionalOnProperty;
import com.bxm.component.mq.config.MessageConfigurationProperties;
import com.bxm.component.mq.enums.MessageTypeEnum;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class MessageListenerConditional
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(MessageListenerConditional.class);
    private MessageConfigurationProperties messageConfigurationProperties = new MessageConfigurationProperties();

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map annotationAttributes = metadata.getAnnotationAttributes(MessageConditionalOnProperty.class.getName());
        MessageTypeEnum messageTypeEnum = (MessageTypeEnum)((Object)annotationAttributes.get("type"));
        Environment environment = context.getEnvironment();
        String property = environment.getProperty("component.message.message-type");
        if (property == null) {
            property = this.messageConfigurationProperties.getMessageType();
        }
        return messageTypeEnum.name().equals(property);
    }
}

