package com.bxm.component.bus.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liujia
 * @date 11/29/21 7:42 PM
 **/
@ConfigurationProperties(prefix = "component.event-bus")
@Data
public class ComponentBusConfigurationProperties {

    /**
     * 异步事件总线默认的核心线程数量
     */
    private Integer corePoolSize = Runtime.getRuntime().availableProcessors() * 2 + 1;

    /**
     * 异步事件总线最大线程数量(默认和核心线程数一样)
     */
    private Integer maxPoolSize = Runtime.getRuntime().availableProcessors() * 2 + 1;
}
