package com.bxm.component.bus.event;

import com.bxm.component.bus.guava.SubscriberExceptionContext;
import com.bxm.component.bus.guava.SubscriberExceptionHandler;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * 事件总线中事件处理发生异常时，进行额外处理
 *
 * @author liujia
 * @date 11/29/21 7:35 PM
 **/
@Slf4j
public class LogSubscriberExceptionHandler implements SubscriberExceptionHandler {

    @Override
    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        log.error(exception.getMessage(), exception);

        Method method = context.getSubscriberMethod();
        log.error("Exception thrown by subscriber method "
                + method.getName()
                + '('
                + method.getParameterTypes()[0].getName()
                + ')'
                + " on subscriber "
                + context.getSubscriber()
                + " when dispatching event: "
                + context.getEvent());
    }
}
