/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.bus.config;

import com.bxm.component.bus.config.ComponentBusConfigurationProperties;
import com.bxm.component.bus.config.ComponentEventBus;
import com.bxm.component.bus.config.EventBusImportBeanDefinitionRegistrar;
import com.bxm.component.bus.event.LogSubscriberExceptionHandler;
import com.bxm.component.bus.guava.AsyncEventBus;
import com.bxm.component.bus.guava.EventBus;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={ComponentBusConfigurationProperties.class})
@Import(value={EventBusImportBeanDefinitionRegistrar.class})
public class ComponentBusConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ComponentBusConfiguration.class);
    private ComponentBusConfigurationProperties properties;
    public static final String COMPONENT_ASYNC_EXECUTOR = "COMPONENT_ASYNC_EXECUTOR";
    private Map<String, RejectedExecutionHandler> handlerMap;

    public ComponentBusConfiguration(ComponentBusConfigurationProperties properties) {
        this.properties = properties;
        this.handlerMap = Maps.newHashMap();
        this.handlerMap.put(ThreadPoolExecutor.CallerRunsPolicy.class.getSimpleName(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.handlerMap.put(ThreadPoolExecutor.AbortPolicy.class.getSimpleName(), new ThreadPoolExecutor.AbortPolicy());
        this.handlerMap.put(ThreadPoolExecutor.DiscardPolicy.class.getSimpleName(), new ThreadPoolExecutor.DiscardPolicy());
        this.handlerMap.put(ThreadPoolExecutor.DiscardOldestPolicy.class.getSimpleName(), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    @Bean(name={"asyncEventBus", "eventBus"})
    public EventBus asyncEventBus(@Qualifier(value="COMPONENT_ASYNC_EXECUTOR") Executor executor) {
        AsyncEventBus asyncEventBus = new AsyncEventBus("component-async-event-bus", executor, new LogSubscriberExceptionHandler());
        ComponentEventBus.asyncEventBus = asyncEventBus;
        return asyncEventBus;
    }

    @Bean(value={"COMPONENT_ASYNC_EXECUTOR"})
    @ConditionalOnMissingBean(name={"COMPONENT_ASYNC_EXECUTOR"})
    public Executor asyncEventBusExecutor() {
        LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor executor = new ThreadPoolExecutor((int)this.properties.getCorePoolSize(), (int)this.properties.getMaxPoolSize(), 0L, TimeUnit.MILLISECONDS, blockingQueue, (ThreadFactory)new NamedThreadFactory("component-async-event-bus"));
        log.info("\u521d\u59cb\u5316\u5f02\u6b65\u65f6\u95f4\u5904\u7406\u7ebf\u7a0b\u6c60\uff0c\u6838\u5fc3\u7ebf\u7a0b\u6570\uff1a{}\uff0c\u6700\u5927\u7ebf\u7a0b\u6570\uff1a{},\u62d2\u7edd\u7b56\u7565\uff1a{}", new Object[]{this.properties.getCorePoolSize(), this.properties.getMaxPoolSize(), this.properties.getExecutorRejectHandlerPolicy()});
        executor.allowCoreThreadTimeOut(false);
        executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                log.error("\u8d85\u51fa\u7ebf\u7a0b\u6c60\u5904\u7406\u80fd\u529b,\u5f53\u524d\u62d2\u7edd\u7b56\u7565\uff1a{},\u5f53\u524d\u7ebf\u7a0b\u6267\u884c\u5668\u72b6\u6001\uff1a{}", (Object)ComponentBusConfiguration.this.properties.getExecutorRejectHandlerPolicy(), (Object)executor.toString());
                ComponentBusConfiguration.this.getHandler().rejectedExecution(r, executor);
            }
        });
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)executor);
    }

    private RejectedExecutionHandler getHandler() {
        return this.handlerMap.getOrDefault(this.properties.getExecutorRejectHandlerPolicy(), new ThreadPoolExecutor.AbortPolicy());
    }
}

