/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.tools;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext = null;
    private static Logger LOGGER = LogManager.getLogger(SpringContextHolder.class);

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> Collection<T> getBeans(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return applicationContext.getBeansOfType(requiredType).values();
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            LOGGER.info("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.");
        }
    }

    public void destroy() {
        LOGGER.info("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext);
        applicationContext = null;
    }
}

