package com.bxm.newidea.component.tools;

/**
 * 反射相关的工具类
 * @author liujia 2018/4/11 19:45
 */
public class ReflectionUtils {

    private ReflectionUtils(){}

    /**
     * 判断对象是否未数字
     * @param obj 待判断对象
     * @return true表示obj是数值
     */
    public static boolean isNumeric(Object obj){
        if(null == obj){
            return false;
        }

        Class clasz = obj.getClass();

        return int.class.isAssignableFrom(clasz) ||
                Integer.class.isAssignableFrom(clasz) ||
                float.class.isAssignableFrom(clasz) ||
                Float.class.isAssignableFrom(clasz) ||
                long.class.isAssignableFrom(clasz) ||
                Long.class.isAssignableFrom(clasz) ||
                short.class.isAssignableFrom(clasz) ||
                Short.class.isAssignableFrom(clasz) ||
                byte.class.isAssignableFrom(clasz) ||
                Byte.class.isAssignableFrom(clasz);
    }
}
