package com.bxm.newidea.component.vo;

import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

/**
 * 分页查询参数
 * @author liujia 2018/4/9 17:32
 */
public class PageParam extends BaseParam {

    @ApiModelProperty(value = "分页查询参数，当前是第几页,min[1]")
    private Integer pageNum = 1;

    @ApiModelProperty(value = "分页查询参数，每页显示数量,默认为10,rang[1,200]")
    @Range(min = 0, max = 200)
    private Integer pageSize = 10;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
