package com.bxm.newidea.component.enums;

import com.bxm.newidea.component.vo.BasicParam;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 系统名称枚举，在多个APP共用的模块中，用于区分数据来源
 * @author liujia
 * @date 2020/05/03 10:18
 */
public enum AppNameEnum {
    /**
     * 趣淘金
     */
    FOSSICKER,
    /**
     * 本地万事通
     */
    LOCAL_NEWS;

    /**
     * 根据名称获取enum
     * 如果name为空或者不存在对应的enum 则返回默认的{@link AppNameEnum#FOSSICKER}
     * @param name name
     * @return enum
     */
    public static AppNameEnum getByNameWithDefaultVal(String name) {

        if (StringUtils.isBlank(name)) {
            return FOSSICKER;
        }

        try {
            return AppNameEnum.valueOf(name);
        } catch(Exception e) {

        }
        return FOSSICKER;
    }

    /**
     * 判断是否趣淘金app的请求
     * @param srcApp {@link BasicParam#getSrcApp()}
     * @return
     */
    public static boolean isFossickerApp(String srcApp) {
        return StringUtils.isBlank(srcApp) || Objects.equals(getByNameWithDefaultVal(srcApp), FOSSICKER);
    }

}
