package com.bxm.newidea.component.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Copy from Alibaba Sentinel project
 * 自定义线程构建工厂类，使其具备有规律的名字，并且默认支持捕获子线程的异常
 */
public class NamedThreadFactory implements ThreadFactory {
    private AtomicInteger count = new AtomicInteger(1);

    /**
     * 线程分组
     */
    private ThreadGroup group;

    /**
     * 创建线程名称前缀
     */
    private String namePrefix;

    /**
     * 是否创建主线程
     */
    private boolean daemon;

    /**
     * 异常捕获处理
     */
    private Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon) {
        this(namePrefix, daemon, null);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon, Thread.UncaughtExceptionHandler handler) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
        this.daemon = daemon;

        if (null == handler) {
            this.handler = new UncaughtExceptionHandler();
        }
    }

    @Override
    public Thread newThread(Runnable runnable) {
        //TODO 修改线程名称，增加方便定位问题的信息（IP/类名）
        Thread thread = new Thread(group, runnable, namePrefix + "-thread-" + count.getAndIncrement(), 0);
        thread.setDaemon(daemon);
        thread.setUncaughtExceptionHandler(handler);
        return thread;
    }
}