package com.bxm.newidea.component.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Objects;

/**
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@ApiModel(description = "客户端请求API需要传递的基础参数，用来后续定位问题和进行相关逻辑处理")
@Data
public class BasicParam extends BaseBean {

    @ApiModelProperty(value = "基础参数：平台类型,1:ANDROID,2:IOS,3:WEB,4:快应用,5:小程序", required = true)
    private Integer platform;

    @ApiModelProperty(value = "基础参数：当前APP的上线版本", required = true)
    private String curVer;

    @ApiModelProperty(value = "基础参数：请求渠道来源", required = true)
    private String chnl;

    @ApiModelProperty(value = "基础参数：设备ID", required = true)
    private Long devcId;

    @ApiModelProperty(value = "基础参数：客户端时间", required = true)
    private Long cliTime;

    @ApiModelProperty(value = "基础参数：请求来源的应用编码", required = true)
    private String srcApp;

    /**
     * merge basic 参数
     *
     * @param param 其他基础参数
     */
    public void merge(BasicParam param) {
        if (Objects.nonNull(param)) {
            this.platform = param.getPlatform();
            this.curVer = param.getCurVer();
            this.chnl = param.getChnl();
            this.devcId = param.getDevcId();
            this.cliTime = param.getCliTime();
            this.srcApp = param.getSrcApp();
        }
    }
}