package com.bxm.newidea.component.filter;

import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 用户输入过滤器,根据指定的规则进行过滤
 *
 * @author liujia
 * @date 2020-09-07 15:16
 **/
@Slf4j
public class InputFilter {
    private InputFilter() {
    }

    private String source;

    private boolean removeScript = true;

    private boolean enableLog = true;

    private boolean escape;

    public static InputFilter builder(String source) {
        InputFilter filter = new InputFilter();
        filter.source = source;
        return filter;
    }

    /**
     * 是否过滤HTML标签
     *
     * @param removeScript 是否移除html标签
     * @return 当前对象
     */
    public InputFilter removeScript(boolean removeScript) {
        this.removeScript = removeScript;
        return this;
    }

    /**
     * 是否记录过滤日志，默认记录为INFO级别
     *
     * @param enableLog true表示开启日志记录
     * @return 当前对象
     */
    public InputFilter enableLog(boolean enableLog) {
        this.enableLog = enableLog;
        return this;
    }


    /**
     * 执行最终的过滤
     *
     * @return 过滤后的字符串
     */
    public String filte() {
        String finalResult = source;

        // 过滤HTML代码
        if (removeScript) {
            finalResult = HtmlContentUtils.delHtmlTags(source);
        }

        if (enableLog && !StringUtils.equals(finalResult, source)) {
            log.info("输入的字符串存在隐患，原始内容：{},过滤后的内容：{}", source, finalResult);
        }
        return finalResult;
    }
}
