package com.bxm.component.auto.registry.spring.cloud;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * @author Gonzo
 * @date 2019-12-04 14:59
 */
@Configuration
@ConditionalOnProperty(value = "component.spring.cloud.service-registry.custom.enabled", matchIfMissing = true)
public class EurekaClientServiceRegisterConfiguration {

    @Bean
    @ConditionalOnProperty(
            value = {"spring.cloud.service-registry.auto-registration.enabled"},
            matchIfMissing = true
    )
    public EurekaClientServiceRegistration eurekaClientServiceRegistration(ApplicationContext context,
                                                                           EurekaRegistration registration,
                                                                           CloudEurekaInstanceConfig instanceConfig,
                                                                           ApplicationInfoManager applicationInfoManager) {
        if (Objects.equals(instanceConfig.getInitialStatus(), InstanceInfo.InstanceStatus.UP)
                && instanceConfig instanceof EurekaInstanceConfigBean) {

            // 设置默认初始化状态为STARTING
            ((EurekaInstanceConfigBean) instanceConfig).setInitialStatus(InstanceInfo.InstanceStatus.STARTING);
        }
        return new EurekaClientServiceRegistration(context, registration, applicationInfoManager);
    }

}
