package com.bxm.newidea.cloud.fegin;

import com.bxm.newidea.cloud.constant.EnvConstant;
import com.bxm.newidea.cloud.ribbon.RibbonFilterContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Component
public class HttpRequestInterceptor implements ClientHttpRequestInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestInterceptor.class);

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request);

        String env = RibbonFilterContextHolder.getCurrentContext().get(EnvConstant.ENV_HEADER_KEY);
        if (null != env) {
            requestWrapper.getHeaders().add(EnvConstant.ENV_HEADER_KEY, EnvConstant.PRE_ENV_VALUE);
        }

        LOGGER.debug("request uri:" + request.getURI() + ",env: " + env);

        return execution.execute(requestWrapper, body);
    }
}
