/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.auto.registry.spring.cloud;

import com.bxm.component.graceful.shutdown.event.ShutdownEvent;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

public class EurekaClientServiceRegistration {
    private static final Logger log = LoggerFactory.getLogger(EurekaClientServiceRegistration.class);
    private ApplicationContext context;
    private EurekaRegistration registration;
    private ApplicationInfoManager applicationInfoManager;

    public EurekaClientServiceRegistration(ApplicationContext context, EurekaRegistration registration, ApplicationInfoManager applicationInfoManager) {
        this.context = context;
        this.registration = registration;
        this.applicationInfoManager = applicationInfoManager;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (event.getApplicationContext() == this.context) {
            InstanceInfo remoteInfo;
            log.info("on ApplicationReadyEvent, update eureka client status to UP");
            InstanceInfo info = this.registration.getApplicationInfoManager().getInfo();
            this.applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
            Application application = this.registration.getEurekaClient().getApplication(info.getAppName());
            if (Objects.nonNull(application) && Objects.nonNull(remoteInfo = application.getByInstanceId(info.getId())) && Objects.equals(remoteInfo.getStatus(), InstanceInfo.InstanceStatus.OUT_OF_SERVICE)) {
                this.registration.getEurekaClient().setStatus(InstanceInfo.InstanceStatus.UP, info);
            }
        }
    }

    @Order(value=-2147483648)
    @EventListener(value={ShutdownEvent.class})
    public void onApplicationEvent(ShutdownEvent event) {
        if (event.getApplicationContext() == this.context) {
            log.info("on ShutdownEvent\uff0cupdate eureka client status to OUT_OF_SERVICE");
            InstanceInfo info = this.registration.getApplicationInfoManager().getInfo();
            this.registration.getEurekaClient().setStatus(InstanceInfo.InstanceStatus.OUT_OF_SERVICE, info);
        }
    }
}

