/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.model.param;

import com.bxm.newidea.component.param.BasicParam;
import com.google.common.collect.Maps;
import java.util.Map;

public class PointParam {
    private String did;
    private String v;
    private String e;
    private String ev;
    private String p;
    private String dtype;
    private Map<String, String> extendMap;

    private PointParam() {
    }

    public static PointParam build() {
        PointParam param = new PointParam();
        param.p = "gold";
        param.extendMap = Maps.newHashMap();
        return param;
    }

    public static PointParam build(BasicParam basicParam) {
        PointParam param = PointParam.build();
        param.dtype = String.valueOf(basicParam.getPlatform());
        param.did = String.valueOf(basicParam.getDevcId());
        param.v = basicParam.getCurVer();
        if (basicParam.getCliTime() != null) {
            param.put("ts", String.valueOf(basicParam.getCliTime()));
        } else {
            param.put("ts", String.valueOf(System.currentTimeMillis()));
        }
        return param;
    }

    public PointParam put(String key, String value) {
        this.extendMap.put(key, value);
        return this;
    }

    public Map<String, String> getMap() {
        this.extendMap.put("did", this.did);
        this.extendMap.put("e", this.e);
        this.extendMap.put("ev", this.ev);
        this.extendMap.put("v", this.v);
        this.extendMap.put("p", this.p);
        this.extendMap.put("dtype", this.dtype);
        return this.extendMap;
    }

    public PointParam did(String did) {
        this.did = did;
        return this;
    }

    public PointParam dtype(String dtype) {
        this.dtype = dtype;
        return this;
    }

    public PointParam v(String v) {
        this.v = v;
        return this;
    }

    public PointParam e(String e) {
        this.e = e;
        return this;
    }

    public PointParam ev(String ev) {
        this.ev = ev;
        return this;
    }

    public PointParam p(String p) {
        this.p = p;
        return this;
    }

    public String toString() {
        return "PointParam{did='" + this.did + '\'' + ", v='" + this.v + '\'' + ", e='" + this.e + '\'' + ", ev='" + this.ev + '\'' + ", p='" + this.p + '\'' + ", dtype='" + this.dtype + '\'' + ", extendMap=" + this.extendMap + '}';
    }
}

