package com.bxm.newidea.component.util;

import com.bxm.newidea.component.model.param.PointParam;
import lombok.extern.slf4j.Slf4j;

/**
 * 数据数据埋点工具类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:15 下午
 */
@Slf4j
public class PointReportUtils {

    private static ReportConsumer reportConsumer;

    private PointReportUtils() {

    }

    static void setReportConsumer(ReportConsumer reportConsumer) {
        PointReportUtils.reportConsumer = reportConsumer;
    }

    /**
     * 上报数据埋点
     *
     * @param param 埋点参数
     */
    public static void report(PointParam param) {
        reportConsumer.consume(param.getFinalData());
    }
}