package com.bxm.newidea.component.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/8 2:51 下午
 */
@ConfigurationProperties(prefix = "component.dot")
@Data
public class PointInfoProperties {

    /**
     * 上报埋点的URL地址
     * 默认的全局地址
     */
    private String reportPointUrl;

    /**
     * 上报埋点的版本，如果具体埋点未提供版本则采用此值
     */
    private String reportPointVersion;

    /**
     * 数据埋点中的项目名称
     * 默认名称，多个项目并存的情况则需要手工设置
     */
    private String projectName;

    /**
     * 不同的项目对应的埋点地址，具有最高的优先级
     * 不同项目的上报地址，可以根据项目名称进行额外设置
     * key：项目名称
     * value：具体项目的上报版本
     */
    private Map<String, String> projectPointUrlMap = Maps.newHashMap();

    /**
     * 不同项目对应的埋点版本
     * key：项目名称
     * value：埋点版本
     */
    private Map<String, String> projectVersionMap = Maps.newHashMap();
}