package com.bxm.newidea.component.tools;

import static com.bxm.newidea.component.constant.LocationConstant.EARTH_RADIUS;

/**
 * 高德地图工具类
 */
public class GouldUtils {

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    /**
     * 通过经纬度获取距离(单位：米)
     */
    public static double getDistance( double lng1,double lat1 ,double lng2, double lat2) {
        double radLat1 = rad(lat1);
        double radLat2 = rad(lat2);
        double a = radLat1 - radLat2;
        double b = rad(lng1) - rad(lng2);
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2)
                + Math.cos(radLat1) * Math.cos(radLat2)
                * Math.pow(Math.sin(b / 2), 2)));
        s = s * EARTH_RADIUS;
        s = Math.round(s * 10000d) / 10000d;
        s = s * 1000;
        return s;
    }



    /**
     * 判断是否在区域范围内
     *
     * @param lng      1点的经度
     * @param lat      1点的纬度
     * @param lng2     2点的经度
     * @param lat2     2点的纬度
     * @param radius 半径  单位米
     * @return true or false
     */
    public static boolean isWithinTheScopeOf(double lng, double lat, double lng2, double lat2, Long radius) {
        double distance1 = getDistance(Double.valueOf(lng), Double.valueOf(lat), lng2, lat2);

        double distance2 = getDistance(Double.valueOf(lng), Double.valueOf(lat), lng2, lat2);

        double distance3 = getDistance(lng, lat, lng2, lat2);

        return distance1 <= radius || distance2 <= radius || distance3 <= radius;
    }



    /**
     * 判断是否在区域内
     *
     * @param latitude 经度
     * @param lngitude 纬度
     * @param areaLatitude1 区域纬度1
     * @param areaLatitude2 区域纬度2
     * @param areaLongitude1 区域经度1
     * @param areaLongitude2 区域经度2
     * @return
     */
    public static boolean isInArea(Double latitude, Double lngitude, Double areaLatitude1, Double areaLatitude2, Double areaLongitude1, Double areaLongitude2) {
        //如果在纬度的范围内
        if (isInRange(latitude, areaLatitude1, areaLatitude2)) {
            //如果都在东半球或者都在西半球
            if (areaLongitude1 * areaLongitude2 > 0) {
                if (isInRange(lngitude, areaLongitude1, areaLongitude2)) {
                    return true;
                } else {
                    return false;
                }
            } else {//如果一个在东半球，一个在西半球
                //如果跨越0度经线在半圆的范围内
                if (Math.abs(areaLongitude1) + Math.abs(areaLongitude2) < 180.0) {
                    if (isInRange(lngitude, areaLongitude1, areaLongitude2)) {
                        return true;
                    } else {
                        return false;
                    }
                } else {//如果跨越180度经线在半圆范围内
                    //东半球的经度范围left-180
                    double left = Math.max(areaLongitude1, areaLongitude2);
                    //西半球的经度范围right-（-180）
                    double right = Math.min(areaLongitude1, areaLongitude2);
                    if (isInRange(lngitude, left, 180.0) || isInRange(lngitude, right, -180.0)) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }
    private static boolean isInRange(Double point, Double left, Double right) {
        if (point >= Math.min(left, right) && point <= Math.max(left, right)) {
            return true;
        } else {
            return false;
        }
    }




}