package com.huawei.push.javasdk.messaging;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * A single-threaded scheduled executor implementation. Allows naming the threads, and spawns
 * new threads as daemons.
 */
public class HuaweiScheduledExecutor extends ScheduledThreadPoolExecutor {

    public HuaweiScheduledExecutor(ThreadFactory threadFactory, String name) {
        this(threadFactory, name, null);
    }

    public HuaweiScheduledExecutor(ThreadFactory threadFactory, String name, Thread.UncaughtExceptionHandler handler) {
        super(1, decorateThreadFactory(threadFactory, name, handler));
        setRemoveOnCancelPolicy(true);
    }

    static ThreadFactory getThreadFactoryWithName(ThreadFactory threadFactory, String name) {
        return decorateThreadFactory(threadFactory, name, null);
    }

    private static ThreadFactory decorateThreadFactory(
            ThreadFactory threadFactory, String name, Thread.UncaughtExceptionHandler handler) {
        checkArgument(!Strings.isNullOrEmpty(name));
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder()
                .setThreadFactory(threadFactory)
                .setNameFormat(name)
                .setDaemon(true);
        if (handler != null) {
            builder.setUncaughtExceptionHandler(handler);
        }
        return builder.build();
    }
}
