/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.push.javasdk.messaging;

import com.google.common.collect.ImmutableList;
import com.huawei.push.javasdk.messaging.HuaweiOption;
import com.huawei.push.javasdk.messaging.HuaweiScheduledExecutor;
import com.huawei.push.javasdk.messaging.HuaweiService;
import com.huawei.push.javasdk.messaging.ThreadManager;
import com.huawei.push.javasdk.messaging.TokenRefresher;
import com.huawei.push.javasdk.util.ValidatorUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiApp {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiApp.class);
    private String appId;
    private HuaweiOption option;
    private static final Object appsLock = new Object();
    private static final Map<String, HuaweiApp> instances = new HashMap<String, HuaweiApp>();
    private final Map<String, HuaweiService> services = new HashMap<String, HuaweiService>();
    private TokenRefresher tokenRefresher;
    private volatile ScheduledExecutorService scheduledExecutor;
    private ThreadManager threadManager;
    private ThreadManager.HuaweiExecutors executors;
    private final AtomicBoolean deleted = new AtomicBoolean();
    private final Object lock = new Object();

    private HuaweiApp(HuaweiOption option) {
        ValidatorUtils.checkArgument(option != null, "HuaweiOption must not be null");
        this.option = option;
        this.appId = option.getCredential().getAppId();
        this.tokenRefresher = new TokenRefresher(this);
        this.threadManager = option.getThreadManager();
        this.executors = this.threadManager.getHuaweiExecutors(this);
    }

    public HuaweiOption getOption() {
        return this.option;
    }

    public String getAppId() {
        return this.appId;
    }

    public static HuaweiApp getInstance(String appId) {
        Object object = appsLock;
        synchronized (object) {
            HuaweiApp app = instances.get(appId);
            if (app != null) {
                return app;
            }
            String errorMessage = MessageFormat.format("HuaweiApp with id {0} doesn't exist", appId);
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HuaweiApp initializeApp(HuaweiOption option) {
        HuaweiApp app;
        String appId = option.getCredential().getAppId();
        Object object = appsLock;
        synchronized (object) {
            ValidatorUtils.checkState(!instances.containsKey(appId), "HuaweiApp with id " + appId + " already exists!");
            app = new HuaweiApp(option);
            instances.put(appId, app);
            app.startTokenRefresher();
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HuaweiApp> getApps() {
        Object object = appsLock;
        synchronized (object) {
            return ImmutableList.copyOf(instances.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAllAppIds() {
        HashSet<String> allAppIds = new HashSet<String>();
        Object object = appsLock;
        synchronized (object) {
            for (HuaweiApp app : instances.values()) {
                allAppIds.add(app.getAppId());
            }
        }
        ArrayList<String> sortedIdList = new ArrayList<String>(allAppIds);
        Collections.sort(sortedIdList);
        return sortedIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.lock;
        synchronized (object) {
            boolean valueChanged = this.deleted.compareAndSet(false, true);
            if (!valueChanged) {
                return;
            }
            try {
                this.getOption().getHttpClient().close();
                this.getOption().getCredential().getHttpClient().close();
            }
            catch (IOException e) {
                logger.debug("Fail to close httpClient");
            }
            for (HuaweiService service : this.services.values()) {
                service.destroy();
            }
            this.services.clear();
            this.tokenRefresher.stop();
            this.threadManager.releaseHuaweiExecutors(this, this.executors);
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdown();
                this.scheduledExecutor = null;
            }
        }
        object = appsLock;
        synchronized (object) {
            instances.remove(this.getAppId());
        }
    }

    private void checkNotDeleted() {
        String errorMessage = MessageFormat.format("HuaweiApp with id {0} was deleted", this.getAppId());
        ValidatorUtils.checkState(!this.deleted.get(), errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService singleScheduledExecutorService() {
        if (this.scheduledExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkNotDeleted();
                if (this.scheduledExecutor == null) {
                    this.scheduledExecutor = new HuaweiScheduledExecutor(this.getThreadFactory(), "huawei-scheduled-worker");
                }
            }
        }
        return this.scheduledExecutor;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadManager.getThreadFactory();
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return this.singleScheduledExecutorService();
    }

    ScheduledFuture<?> schedule(Runnable runnable, long initialDelay, long period) {
        return this.getScheduledExecutorService().scheduleWithFixedDelay(runnable, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addService(HuaweiService service) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotDeleted();
            ValidatorUtils.checkArgument(!this.services.containsKey(service.getId()), "service already exists");
            this.services.put(service.getId(), service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HuaweiService getService(String id) {
        Object object = this.lock;
        synchronized (object) {
            return this.services.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTokenRefresher() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotDeleted();
            this.tokenRefresher.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstancesForTest() {
        Object object = appsLock;
        synchronized (object) {
            for (HuaweiApp app : ImmutableList.copyOf(instances.values())) {
                app.delete();
            }
            instances.clear();
        }
    }
}

