package com.huawei.push.javasdk.exception;

import com.google.common.base.Strings;
import com.huawei.push.javasdk.util.ValidatorUtils;

/**
 * Base class for all HCM exceptions
 */
public class HuaweiException extends Exception {

    public HuaweiException(String detailMessage) {
        super(detailMessage);
        ValidatorUtils.checkArgument(!Strings.isNullOrEmpty(detailMessage), "Detail message must not be empty");
    }

    public HuaweiException(String detailMessage, Throwable cause) {
        super(detailMessage, cause);
        ValidatorUtils.checkArgument(!Strings.isNullOrEmpty(detailMessage), "Detail message must not be empty");
    }
}
