package com.bxm.component.jwt.builder;

import io.jsonwebtoken.SignatureAlgorithm;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author liujia
 * @date 6/2/21 7:15 PM
 **/
public class TokenBuildParam {

    public static TokenBuildParam create() {
        return new TokenBuildParam();
    }

    /**
     * 头部信息
     */
    private Map<String, Object> headerMap = new HashMap<>();

    /**
     * payload 主体内容部分
     * base64简单加密，相当于明文，不要放敏感内容
     */
    private Map<String, Object> claimMap = new HashMap<>();

    /**
     * 加密方式
     */
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;

    /**
     * 加密密钥
     */
    private String signatureKey;

    /**
     * 过期时间
     */
    private Date expirationTime;

    /**
     * 发行时间
     */
    private Date issueDate;

    public Map<String, Object> getHeaderMap() {
        return headerMap;
    }

    public TokenBuildParam setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap;
        return this;
    }

    public TokenBuildParam putHeader(String key, Object value) {
        this.headerMap.put(key, value);
        return this;
    }

    public Map<String, Object> getClaimMap() {
        return claimMap;
    }

    public TokenBuildParam putClaim(String key, String value) {
        this.claimMap.put(key, value);
        return this;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return signatureAlgorithm;
    }

    public TokenBuildParam setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        return this;
    }

    public String getSignatureKey() {
        return signatureKey;
    }

    public TokenBuildParam setSignatureKey(String signatureKey) {
        this.signatureKey = signatureKey;
        return this;
    }

    public Date getExpirationTime() {
        return expirationTime;
    }

    public TokenBuildParam setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public TokenBuildParam setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }
}
