/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.mircometer.config;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class ShardingDataSourcePoolMetricsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ShardingDataSource.class, HikariDataSource.class})
    static class ShardingDataSourceMetricsConfiguration {
        private static final Logger logger = LoggerFactory.getLogger(ShardingDataSourceMetricsConfiguration.class);
        private final MeterRegistry registry;

        ShardingDataSourceMetricsConfiguration(MeterRegistry registry) {
            this.registry = registry;
        }

        @Autowired
        void bindMetricsRegistryToHikariDataSources(Collection<DataSource> dataSources) {
            for (DataSource dataSource : dataSources) {
                ShardingDataSource shardingDataSource = (ShardingDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, ShardingDataSource.class);
                Collection shardDataSources = shardingDataSource.getDataSourceMap().values();
                for (DataSource ds : shardDataSources) {
                    HikariDataSource hikariDataSource = (HikariDataSource)DataSourceUnwrapper.unwrap((DataSource)ds, HikariDataSource.class);
                    if (hikariDataSource == null) continue;
                    this.bindMetricsRegistryToHikariDataSource(hikariDataSource);
                }
            }
        }

        private void bindMetricsRegistryToHikariDataSource(HikariDataSource hikari) {
            if (hikari.getMetricRegistry() == null && hikari.getMetricsTrackerFactory() == null) {
                try {
                    hikari.setMetricsTrackerFactory((MetricsTrackerFactory)new MicrometerMetricsTrackerFactory(this.registry));
                }
                catch (Exception ex) {
                    logger.warn("Failed to bind Hikari metrics: {}", (Object)ex.getMessage());
                }
            }
        }
    }
}

