package com.bxm.component.mybatis.dbshunt.impl;

import com.bxm.component.mybatis.dbshunt.DBstrategy;
import com.bxm.component.mybatis.dbshunt.param.ShuntParam;
import com.bxm.component.mybatis.dbshunt.strategy.TableHandlerProxy;
import com.bxm.newidea.component.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/6/28 15:46
 */
@Service
@Slf4j
public class DBstrategyImpl implements DBstrategy {

    @Autowired
    private TableHandlerProxy tableHandlerProxy;

    @Override
    public void dbShunt(ShuntParam shuntParam) {
        log.info("分表数据执行开始，shuntParam：{}", JSON.toJSONString(shuntParam));
        tableHandlerProxy.handleTableData(shuntParam);
    }
}
