/**
 * Copyright (C) 2016 思创数码科技股份有限公司浙江分公司
 * 版权所有
 * 文  件  名：AbstractCellConverter.java
 * 功能概要：
 * 创建日期：2016年5月27日・liuj(liujia1@strongit.com.cn)
 */
package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.config.ExcelConstant;
import com.bxm.component.office.excel.format.CellValueConvertContext;
import com.bxm.component.office.excel.format.CellValueConverter;
import com.bxm.component.office.excel.format.CellValueManage;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;

/**
 * excel属性值转换器抽象类
 * @author liuj(liujia1 @ strongit.com.cn)
 * @version V1.1.1
 */
public abstract class AbstractCellConverter implements CellValueConverter {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    protected CellValueManage manage;

    @Override
    public void setCellValueManage(CellValueManage manage) {
        this.manage = manage;
    }

    protected CellValueConvertContext getContext() {
        return manage.getContext();
    }

    protected Object getSetValue() {
        return getContext().getExtend(ExcelConstant.SET_CELL_VALUE);
    }

    protected Class<?> getValueClass() {
        return (Class<?>) getContext().getExtend(ExcelConstant.CELL_VALUE_CLASS);
    }

    protected Cell getCell() {
        return getContext().getCell();
    }

    protected int getCellType() {
        return getContext().getCell().getCellType();
    }

    /**
     * 防止数字以科学计数法显示数值
     * @return
     */
    protected String getDoubleCellStringValue() {
        return new BigDecimal(getCell().getNumericCellValue()).toPlainString();
    }

}
