package com.bxm.component.office.excel.format.impl;

import com.bxm.component.office.excel.format.config.CellTypeEnum;
import org.apache.poi.ss.usermodel.Cell;

/**
 * 功能说明：<br/>
 * 字符串转换器
 * <br/>
 * 开发人员：liuj(liujia1@strongit.com.cn)<br/>
 * 开发时间：2016年3月3日<br/>
 */
public class StringCellConverter extends AbstractCellConverter {

    @Override
    public boolean isMatch(CellTypeEnum cellType) {
        return CellTypeEnum.STRING.equals(cellType);
    }

    @Override
    public void setValue() {
        Object setValue = getSetValue();
        if (null == setValue) {
            setValue = "";
        }
        getCell().setCellValue(setValue.toString());
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Object getValue() {
        int cellType = getCell().getCellType();
        if (Cell.CELL_TYPE_NUMERIC == cellType) {
            return getDoubleCellStringValue();
        } else if (Cell.CELL_TYPE_STRING == cellType) {
            return getCell().getStringCellValue();
        }

        return "";
    }

}
