package com.bxm.component.office.excel.parse.impl;

import com.bxm.component.office.excel.config.ExcelConstant;
import com.bxm.component.office.excel.parse.setting.ParseHeader;
import com.bxm.component.office.exception.ParseException;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.google.common.collect.Lists;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 功能说明：<br/>
 * excel简单解析，针对单sheet，数据量较小的情况
 * <br/>
 * 开发时间：2016年4月22日<br/>
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class SimpleExcelParser<T> extends AbstractExcelParser<T> {

    private Map<String, Integer> headerMap = new HashMap<String, Integer>();

    private int currentRow = 0;

    private int currentCol = 0;

    @Override
    protected List<T> parseSheet() {
        currentRow = 0;
        List<T> result = Lists.newArrayList();

        Iterator<Row> rowIterator = sheet.rowIterator();

        while (rowIterator.hasNext()) {

            Row row = rowIterator.next();
            currentRow = row.getRowNum();
            // 对设置需要跳过的列进行处理
            if (currentRow < setting.getHeaderRow()) {
                continue;
            }
            if (currentRow == setting.getHeaderRow()) {
                parseHeader(row);
                continue;
            }

            // 进行列处理
            result.add(parseRow(row));
        }

        return result;
    }

    private void parseHeader(Row row) {
        if (setting.isHeaderModel()) {
            currentCol = 0;
            Iterator<Cell> cellIteratro = row.cellIterator();
            while (cellIteratro.hasNext()) {
                Cell cell = cellIteratro.next();

                getContext().setCell(cell);
                getContext().addExtend(ExcelConstant.CELL_VALUE_CLASS, String.class);

                Object title = cellValueManage.getValue();

                headerMap.put(null == title ? currentCol + "未定义" : title.toString(), currentCol);

                currentCol++;
            }

            // 如果表头设置参数中存在超过excel列头的数据则添加到解析表头map中
            for (ParseHeader header : setting.getHeads()) {
                if (!headerMap.containsKey(header.getTitle())) {
                    headerMap.put(header.getTitle(), currentCol++);
                }
            }
        }
    }

    @SuppressWarnings("unchecked")
    private T parseRow(Row row) {
        T obj;
        try {
            obj = (T) setting.getEntityClasz().newInstance();
            for (ParseHeader header : setting.getHeads()) {
                int index = header.getColIndex();
                if (setting.isHeaderModel()) {
                    Integer intIndex = headerMap.get(header.getTitle());
                    if (null == intIndex) {
                        LOGGER.warn("Excel中不存在列标题为：{0}的列", header.getTitle());
                        continue;
                    }
                    index = intIndex;
                }

                Field field = getField(header.getField());

                if (field == null) {
                    continue;
                }

                Cell cell = row.getCell(index);

                Object value = null;

                // 不存在指定的列，但是设置了默认值时，采用默认值进行赋值
                if (null == cell && null != header.getDefaultValue()) {
                    value = header.getDefaultValue().getValue();
                } else if (null != cell) {
                    // 进行正常的解析
                    getContext().setCell(row.getCell(index));
                    getContext().setCellType(header.getCellType());
                    getContext().addExtend(ExcelConstant.CELL_VALUE_CLASS, field.getType());
                    getContext().addExtend(ExcelConstant.PARSE_HEADER, header);

                    value = cellValueManage.getValue();
                }

                ReflectionUtils.makeAccessible(field);
                ReflectionUtils.setField(field, obj, value);
            }
        } catch (InstantiationException | IllegalAccessException e) {
            LOGGER.error(e.getMessage(), e);
            throw new ParseException(e.getMessage());
        }
        return obj;
    }

    private Field getField(String fieldName) {
        Field field = ReflectionUtils.findField(setting.getEntityClasz(), fieldName);

        if (field == null) {
            LOGGER.warn("[{0}]在[{1}]中未定义，请检查拼写是否正确", fieldName, setting.getEntityClasz());
        }
        return field;
    }

}
